require("dotenv").config(); // ALLOWS ENVIRONMENT VARIABLES TO BE SET ON PROCESS.ENV SHOULD BE AT TOP

const express = require("express");
const app = express();
const http = require("http");
const server = http.createServer(app);
const fileUpload = require("express-fileupload");
const path = require("path");
const auth = require("./middleware/auth");
const chatControllers = require("./controllers/chatControllers");
const db = require("./models");
const Message = db.message;

const cron = require("node-cron");
const Sender = db.sender;
const Op = db.Sequelize.Op;
const moment = require("moment");

const socket = require("socket.io");
const { emit } = require("process");
const io = socket(server);

// global.io = io;
// global.io.on('connection', WebSockets.connection);
// io.on("connection", WebSockets.connection);

// Your function to be executed daily
function yourDailyFunction() {
  console.log("Running your daily function...");

  // Add your logic here
  Sender.update(
    { status: "Expired" },
    {
      where: [
        {
          status: "Active",
          deliveryTime: { [Op.lt]: moment(Date.now()).format("YYYY-MM-DD") }
        }
      ]
    }
  );
}

// Schedule the function to run every day at a specific time (e.g., 3:30 AM)
cron.schedule(
  "0 0 * * *",
  async () => {
    yourDailyFunction();
  },
  {
    scheduled: true,
    timezone: "Europe/Berlin" // Replace with your timezone (e.g., 'America/New_York')
  }
);

console.log("Scheduled task to run daily.");

// //creating chat func
const users = {};

io.on("connection", function(client) {
  var userId = client.handshake.query["userId"];
  console.log("A user is connected..." + client.id);
  console.log(userId + " Ovo je nesto novo");
  users[client.id] = { userId: userId, roomId: null };
  chatControllers.editStatus(client.handshake.query["userId"], true);
  client.on("disconnect", () => {
    console.log(`socket ${client.id} disconnected`);
    chatControllers.editStatus(userId, false);
    delete users[client.id];
  });

  client.on("error", function(err) {
    console.log("Error detected", client.id);
    console.log(err);
  });

  client.on("message", message => {
    // for (const [socketId, userData] of Object.entries(users)) {
    //   console.log(
    //     `Socket ID: ${socketId}, User ID: ${userData.userId}, Room ID: ${userData.roomId}`
    //   );
    // }
    try {
      const user = Object.keys(users).find(
        key => users[key].userId == message.receiver_id
      );
      console.log(users[user]);
      if (typeof user != "undefined") {
        if (users[user].roomId == message.chat_id) {
          message.readed = true;
        } else {
          message.readed = false;
        }
      }
      Message.create(message)
        .then(data => {
          io.in(message.chat_id).emit("message", data);
          io.emit("lastMessage", data);
        })
        .catch(err => {
          console.log(err.message || "ERROR");
        });
    } catch (err) {
      console.log(err.message + " FAILD!");
    }
  });

  client.on("join", room => {
    // console.log(room + "  aktiviran sam");
    // console.log(client.rooms);
    // console.log(io.sockets);
    users[client.id].roomId = room;

    client.join(room);

    console.log(users);
  });

  client.on("leave", room => {
    users[client.id].roomId = null;
    client.leave(room);
    console.log(users);
  });

  client.on("feedback", data => {
    // console.log(data);
    client.broadcast
      .in(data["room"])
      .emit("feedback", { room: data["room"], isTyping: data["isTyping"] });
  });
});

const socketIoObject = io;
module.exports.socketIoObject = socketIoObject;

// Middleware
app.use(fileUpload());
app.use(express.json()); // parse json bodies in the request object

// Redirect requests to endpoint starting with /posts to postRoutes.js
app.use("/api/users", require("./routes/userRoutes"));
app.use("/api/teleporter", auth, require("./routes/teleporterRoutes"));
app.use("/api/sender", auth, require("./routes/senderRoutes"));
app.use("/api/reciver", require("./routes/reciverRoutes"));
app.use("/api/chat", auth, require("./routes/chatRoutes"));
app.use("/api/review", auth, require("./routes/reviewRoutes"));
app.use("/api/notification", require("./routes/notificationRoutes"));

// app.use("/contractor", require("./routes/contractorRoutes"));
// app.use("/api", require("./routes/offerRoutes"));
// app.use("/api", require("./routes/jobRoutes"));

//api to upload images sender
app.post("/upload", (req, res, next) => {
  try {
    // Get the file that was set to our field named "image"
    const { images } = req.files;
    const data = [];

    if (Array.isArray(images) === false) {
      if (
        images.data.toString("hex", 0, 4) == "89504e47" ||
        images.data.toString("hex", 0, 4) == "ffd8ffe0"
      ) {
        // Move the uploaded image to our upload folder
        images.mv(__dirname + "/upload/" + images.name);

        //   const url = "http://localhost:3000/images/" + image.name
        const url =
          "https://api.teleport.scyllasoftware.rs/images/" + images.name;
        data.push({ imagePath: url });
        // All good
      }
      return res.status(200).send({
        status: true,
        message: "Successfuly uploaded.",
        data: data
      });
    } else {
      for (var i = 0; i < images.length; i++) {
        if (validateDocumentType(images[i])) {
          // Move the uploaded image to our upload folder
          images[i].mv(__dirname + "/upload/" + images[i].name);

          //   const url = "http://localhost:3000/images/" + image.name
          const url =
            "https://api.teleport.scyllasoftware.rs/images/" + images[i].name;
          data.push({ imagePath: url });
          // All good
        }
      }
      return res.status(200).send({
        status: true,
        message: "Successfuly uploaded.",
        data: data
      });
    }
  } catch (err) {
    return res.status(200).send({
      status: false,
      message: "Some error occurred while uploading images.",
      data: null
    });
  }
});

// check if the file is valid image
function validateDocumentType(file) {
  const validTypes = ["image/jpeg", "image/png"];
  const maxSize = 5 * 1024 * 1024; // 5MB
  console.log(validTypes.includes(file.mimetype));

  return validTypes.includes(file.mimetype) && file.size < maxSize;
}

// upload userImage
app.post("/uploadUser", (req, res, next) => {
  try {
    const { image } = req.files;
    if (validateDocumentType(image)) {
      // Move the uploaded image to our upload folder
      image.mv(__dirname + "/upload/" + image.name);

      //   const url = "http://localhost:3000/images/" + image.name
      // "http://api.teleport.scyllasoftware.rs/images/"
      const url = "https://api.teleport.scyllasoftware.rs/images/" + image.name;
      // All good

      return res.status(200).send({
        status: true,
        message: "Successfuly uploaded.",
        data: { imagePath: url }
      });
    }
    return res.status(200).send({
      status: false,
      message: "Faild upload.",
      data: null
    });
  } catch (err) {
    return res.status(200).send({
      status: false,
      message: err.message || "Some error occurred while uploading images.",
      data: null
    });
  }
});

//show images
app.use("/images", express.static(path.resolve(__dirname, "upload")));
app.use("/voices", express.static(path.resolve(__dirname, "voices")));

// Global Error Handler. IMPORTANT function params MUST start with err
app.use((err, req, res, next) => {
  console.log(err.stack);
  console.log(err.name);
  console.log(err.code);

  res.status(500).json({
    message: "Something went rely wrong"
  });
});

// Listen on pc port
const PORT = process.env.PORT || 3000;
server.listen(PORT, () => console.log(`Server running on PORT ${PORT}`));

server.on("listening", () => {
  console.log(`Listening on port:: http://localhost:/`);
});
