const express = require("express");
const auth = require("../middleware/auth");

const userControllers = require("../controllers/userControllers");

const router = express.Router();

router.post("/register", userControllers.register);
router.post("/login", userControllers.login);
router.put("/:id", auth, userControllers.edit);
router.put("/:id/editImage", auth, userControllers.editImage);
router.post("/activate", userControllers.activateUser);
router.get("/profile/:user_id", auth, userControllers.getUserProfile);
router.post("/:user_id/savePushToken", userControllers.savePushToken);

module.exports = router;
