const dbConfig = require("../config/db.js");

const Sequelize = require("sequelize");
const sequelize = new Sequelize(dbConfig.DB, dbConfig.USER, dbConfig.PASSWORD, {
  host: dbConfig.HOST,
  dialect: dbConfig.dialect,
  operatorsAliases: 0,
  pool: {
    max: dbConfig.pool.max,
    min: dbConfig.pool.min,
    acquire: dbConfig.pool.acquire,
    idle: dbConfig.pool.idle
  }
});

const db = {};

db.Sequelize = Sequelize;
db.sequelize = sequelize;

// db.animal = require("./Animal.js")(sequelize, Sequelize);
db.user = require("./User.js")(sequelize, Sequelize);
db.reciver = require("./Reciver.js")(sequelize, Sequelize);
db.sender = require("./Sender.js")(sequelize, Sequelize);
db.teleporter = require("./Teleporter.js")(sequelize, Sequelize);
db.chat = require("./Chat.js")(sequelize, Sequelize);
db.message = require("./Message.js")(sequelize, Sequelize);
db.chatUsers = require("./ChatUsers")(sequelize, Sequelize);
db.image = require("./Image.js")(sequelize, Sequelize);
db.review = require("./Review.js")(sequelize, Sequelize);
db.notification = require("./Notification.js")(sequelize, Sequelize);

db.sender.hasMany(db.image, { foreignKey: "sender_id" });
db.user.hasMany(db.image, { foreignKey: "user_id" });
db.user.hasMany(db.teleporter, {
  foreignKey: "user_id"
});
db.user.hasMany(db.sender, {
  foreignKey: "user_id"
});

db.sender.belongsTo(db.user, {
  foreignKey: "user_id"
});

db.teleporter.belongsTo(db.user, { foreignKey: "user_id" });
db.user.hasMany(db.reciver, { foreignKey: "user_id" });

db.sender.hasOne(db.reciver, { foreignKey: "sender_id" });
db.reciver.belongsTo(db.sender, {
  foreignKey: "sender_id"
});

db.user.belongsToMany(db.chat, {
  through: db.chatUsers,
  foreignKey: "user_id"
});
db.chat.belongsToMany(db.user, {
  through: db.chatUsers,
  foreignKey: "chat_id"
});
db.user.hasMany(db.review, { foreignKey: "user_id" });
db.user.hasMany(db.chatUsers, { as: "chatUsers", foreignKey: "user_id" });
db.chat.hasMany(db.chatUsers, { as: "chatUser", foreignKey: "chat_id" });
db.chatUsers.belongsTo(db.user, { foreignKey: "user_id" });
db.chatUsers.belongsTo(db.chat, { foreignKey: "chat_id" });
db.chat.hasMany(db.message, { foreignKey: "chat_id" });
// db.chatUsers.hasOne(db.image, { foreignKey: "user_id" });

module.exports = db;
