module.exports = (sequelize, Sequelize) => {
  const Sender = sequelize.define("senders", {
    user_id: {
      type: Sequelize.INTEGER
    },
    teleporter_id: {
      type: Sequelize.INTEGER
    },
    packageName: {
      type: Sequelize.STRING
    },
    packagePickupDestination: {
      type: Sequelize.STRING
    },
    packageDestination: {
      type: Sequelize.STRING
    },
    deliveryTime: {
      type: Sequelize.DATEONLY
    },
    packageLength: {
      type: Sequelize.FLOAT
    },
    width: {
      type: Sequelize.FLOAT
    },
    height: {
      type: Sequelize.FLOAT
    },
    packageWeight: {
      type: Sequelize.FLOAT
    },
    verificationCode: {
      type: Sequelize.TEXT
    },
    status: {
      type: Sequelize.STRING,
      flag: { type: Sequelize.STRING, allowNull: false }
    }
  });
  return Sender;
};
//status can be Active, Teleporting, Complited, Expired when date is missed
